Option Strict Off
Option Explicit On
Imports GIGATMS.NF

Friend Class frmSaveKey
    Inherits System.Windows.Forms.Form

    Private Const SectorCount As Integer = 16

    Private Sub cmdSave_Click(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles cmdSave.Click
        Dim Index As Short = cmdSave.GetIndex(eventSender)
        Dim szKey As String
        Dim res As Boolean
        Dim nSector, retry As Short

        ' fill to 12 char (6 HEXs)
        txtKEY.Text = txtKEY.Text & New String("0", 12 - Len(txtKEY.Text))

        nSector = cmbSector.SelectedIndex

        Select Case Index
            Case 0
                'Save Key To EEPROM for one sector
                With frmMain
                    If optKEY(0).Checked Then ' Key Type A
                        res = .MF5x1.mfSaveKey(nSector, MifareReader.bKeyTypeConstants.KEY_A, txtKEY.Text)
                    Else ' Key Type B
                        res = .MF5x1.mfSaveKey(nSector, MifareReader.bKeyTypeConstants.KEY_B, txtKEY.Text)
                    End If

                    If res Then ' show status
                        labStatus.Text = "Save Key To EEPROM:OK(" & CStr(nSector) & ")"
                    Else
                        labStatus.Text = "Save Key To EEPROM:NG(" & CStr(nSector) & ")"
                    End If
                End With
            Case 1
                ' Save Key To EEPROM for all sector
                szKey = txtKEY.Text
                With frmMain
                    For nSector = 0 To cmbSector.Items.Count - 1 ' for MIFARE 1K (total 16 sectors)
                        For retry = 1 To 3
                            If optKEY(0).Checked Then ' Key Type A
                                res = .MF5x1.mfSaveKey(nSector, MifareReader.bKeyTypeConstants.KEY_A, szKey)
                            Else ' Key Type B
                                res = .MF5x1.mfSaveKey(nSector, MifareReader.bKeyTypeConstants.KEY_B, szKey)
                            End If

                            If res Then ' show status
                                labStatus.Text = "Save Key To EEPROM:OK(" & CStr(nSector) & ")"
                                Exit For
                            Else
                                labStatus.Text = "Save Key To EEPROM:NG(" & CStr(nSector) & ")"
                                Debug.Print(labStatus.Text)
                            End If
                        Next retry
                        System.Windows.Forms.Application.DoEvents()
                    Next nSector
                End With
            Case 2
                Me.Close()
        End Select
    End Sub

    Private Sub frmSaveKey_Load(ByVal eventSender As System.Object, ByVal eventArgs As System.EventArgs) Handles MyBase.Load
        Dim s As Short

        cmbSector.Items.Clear()
        For s = 0 To SectorCount - 1
            cmbSector.Items.Add("Sector " & CStr(s))
        Next s

        Select Case frmMain.cmbSector.SelectedIndex
            Case 0 To cmbSector.Items.Count - 1
                cmbSector.SelectedIndex = frmMain.cmbSector.SelectedIndex
            Case Else
                cmbSector.SelectedIndex = -1
        End Select

        modMifare.LoadFormPosision(Me)
    End Sub

    Private Sub frmSaveKey_FormClosed(ByVal eventSender As System.Object, ByVal eventArgs As System.Windows.Forms.FormClosedEventArgs) Handles Me.FormClosed
        modMifare.SaveFormPosision(Me)
    End Sub

    Private Sub txtKEY_KeyPress(ByVal eventSender As System.Object, ByVal eventArgs As System.Windows.Forms.KeyPressEventArgs) Handles txtKEY.KeyPress
        Dim KeyAscii As Short = Asc(eventArgs.KeyChar)
        If KeyAscii >= &H30S And KeyAscii <= &H39S Then
        ElseIf KeyAscii >= &H41S And KeyAscii <= &H46S Then
        ElseIf KeyAscii >= &H61S And KeyAscii <= &H66S Then
            KeyAscii = KeyAscii - &H20S
        ElseIf KeyAscii > &H20S Then
            KeyAscii = 0
        End If
        eventArgs.KeyChar = Chr(KeyAscii)
        If KeyAscii = 0 Then
            eventArgs.Handled = True
        End If
    End Sub
End Class